// https://www.ee.columbia.edu/~dpwe/resources/Processing/AudioSocketExample.pde

float kHz=1e3 ;

int bufferSize = 30000 ;
int sampleRate=192000 ;
int bitDepth=16 ;
  
float pi=PI ;

boolean optionSweep=true ;
boolean optionDualSine=false ;

//float fStart=0 ;
//float fStop=sampleRate/2 ;
//float fSpan=fStop-fStart ;
//float fCenter=(fStart+fStop)/2.0 ;
//float fMark=fCenter ;

//float fCenter=60*kHz ;
//float fSpan=6*kHz ;
//float fMark=60*kHz ;

//float fCenter=(66+2.0/3.0)*kHz ;
//float fSpan=6*kHz ;
//float fMark=fCenter ;

float fCenter=77.5*kHz ;
float fSpan=3*kHz ;
float fMark=77.5*kHz ;

float sweepTime=0.05 ;
float amplitude=0.1;

float frqL=500 ;
float frqR=1000 ;
float amplitudeL=0.5 ;
float amplitudeR=0.5 ;

import ddf.minim.*;

float bufL[]=new float[bufferSize] ;
float bufR[]=new float[bufferSize] ;

float phaseL=0 ;
float phaseR=0 ;

float dPhaseL=0 ;
float dPhaseR=0 ;

void setupOsc(){
  println("setupOsc()") ;
  println("frqL=",frqL) ;
  println("frqR=",frqR) ;
  dPhaseL=2*PI*frqL/sampleRate ;
  dPhaseR=2*PI*frqR/sampleRate ;
  }

void setOscSamples1(){
  for(int k=0 ; k<bufferSize ; k++){
    
    bufL[k]=amplitudeL*cos(phaseL) ;
    phaseL+=dPhaseL ;
    if(phaseL>2*PI){ phaseL-=2*PI ; }
    
    bufR[k]=amplitudeR*cos(phaseR) ;
    phaseR+=dPhaseR ;
    if(phaseR>2*PI){ phaseR-=2*PI ; }
    
    }
  }
  
float vv=-1 ;
float v2=-1 ;
float dv=0.1 ;
float frq=0 ;
float phase=0 ;
float vMark=0 ;
float markWidth=0.02 ;
  
void setupSweep(){
  float nSamples=sampleRate*sweepTime ;
  println("nSamples=",nSamples) ;
  dv=2.0/nSamples ;
  println("dv=",dv) ;
  println("fCenter=",fCenter) ;
  println("fSpan=",fSpan) ;
  print("fStart=",fCenter-fSpan/2.0," fStop=",fCenter+fSpan/2.0) ;
  vMark=2.0*(fMark-fCenter)/fSpan ;
  println("  fMark=",fMark," vMark=",vMark) ;
  }

void setSweepSamples1(){
  for(int k=0 ; k<bufferSize ; k++){
    frq=fCenter+vv*fSpan/2.0 ;
    float dPhase=2*pi*frq/sampleRate ;
    phase += dPhase ;
    if(phase>2*pi){ phase-=2*pi ; }
    v2=vv ; if(abs(vv-vMark)<markWidth){ v2=vv+0.2+0.5 ; }
    bufR[k]=amplitude*cos(phase) ;
    bufL[k]=v2 ;
    vv+=dv ;
    if(vv>=1.0){ vv=-1.0 ; }
    }
  }  

void doGenerate(){
  if(optionSweep){ setupSweep() ; }
  if(optionDualSine){ setupOsc() ; }
  while(true){
    if(optionDualSine){ setOscSamples1() ; }
    if(optionSweep){ setSweepSamples1() ; }
    while(socket.waveFetched==false){ delay(1) ; }
    socket.putWave(bufL,bufR) ;
    }
  }

Minim minim;
AudioInput in;
AudioOutput out;
AudioSocket socket;

void setup(){
  size(100, 100);
  minim = new Minim(this);
  println("PCasSweepGen1V06") ;
  in = minim.getLineIn(Minim.STEREO, bufferSize, sampleRate,bitDepth);
  out = minim.getLineOut(Minim.STEREO, bufferSize,sampleRate,bitDepth);
  socket = new AudioSocket(bufferSize);
  in.addListener(socket);
  out.addSignal(socket);
  doGenerate() ;  
  }
