
class AudioSocket implements AudioListener, AudioSignal{

  private float[] left;
  private float[] right;
  float tempL[] ;
  float tempR[] ;

  private int buffer_max;
  private int inpos, outpos;
  private int count;
    
  AudioSocket(int buffer_size) {
    int n_buffers = 4;
    buffer_max = n_buffers * buffer_size;
    left = new float[buffer_max];
    right = new float[buffer_max];
    tempL=new float[bufferSize] ;
    tempR=new float[bufferSize] ;
    
    inpos = 0;
    outpos = 0;
    count = 0;
    }
   
  synchronized void samples(float[] samp) {
    samples(samp, samp);
    }

  boolean waveFetched=false ;
  
  void putWave(float[] LL, float[] RR){
    System.arraycopy(LL, 0, tempL,0, LL.length);
    System.arraycopy(RR, 0, tempR, 0, RR.length);
    waveFetched=false ;
    }
   
  synchronized void samples(float[] sampL, float[] sampR) {
    System.arraycopy(tempL, 0, left, inpos, sampL.length);
    System.arraycopy(tempR, 0, right, inpos, sampR.length);
    waveFetched=true ;
    inpos += sampL.length;
    if (inpos == buffer_max) {
      inpos = 0;
      }
    count += sampL.length;
    }

  void generate(float[] samp) {
    if (count > 0) {
      System.arraycopy(left, outpos, samp, 0, samp.length);
      outpos += samp.length;
      if (outpos == buffer_max) {
        outpos = 0;
        }
      count -= samp.length;
      }
   }

  void generate(float[] sampL, float[] sampR) {
    if (count > 0) {
      System.arraycopy(right, outpos, sampR, 0, sampR.length);
      generate(sampL);
      }
    }
  }
