import ddf.minim.*;
import ddf.minim.spi.AudioStream;
import ddf.minim.ugens.*;

float MHz=1e6 ;
float kHz=1e3 ;
float Ohm=1 ;
float mV=1e-3 ;

float pi=(float) PI ;

float dBmin=-110 ; float dBmax=5 ;

//int fSample=44100 ;
float fSample=192000 ;
int nPoints=32768 ;
int nSamples=nPoints ;
float df=((float)fSample)/nPoints ;
float inputScale=0.5/1.234  ;
 
boolean withSigGen=!true ; 
float sigGenFrq=50e3 ;
float sigGenAmplRms=0.25 ;

boolean withWindow=true ; 
 
//float fCursor=77.5*kHz ;
//float fCursor=(66+2.0/3.0)*kHz ;
//float fStart=fCursor-5000 ;
//float fStop =fCursor+5000 ;

float fCursor=77.5*kHz ;
float fStart=100 ;
float fStop =fSample/2.0;

boolean show=true ;
boolean showmean=true ;
boolean showmax=!true ;

int xMin=0 ; 
//int xMax=nPoints/250 ;
int xMax=nPoints/2 ;
float traceScaleA=25 ; ;
boolean withRefLevel=true ;
float traceScale=1 ;

float yMin=-2050-100 ;
float yMax= 2050+100 ;
boolean autoScaleY=false ;

int  displaySizeX=1200 ;
int  displaySizeY=900 ;
  
int ykFrameX0=10 ;
int ykFrameX1=displaySizeX-10 ;
int ykFrameY0=displaySizeY-10 ;
int ykFrameY1=displaySizeY-200 ;

int dftFrameX0=120 ;
int dftFrameX1=displaySizeX-10 ;
//int dftFrameX1=800-10 ;
int dftFrameY0=displaySizeY-210 ;
int dftFrameY1=displaySizeY-860 ;

FFThelper FFThelp=new FFThelper() ;

int iStart=(int)(fStart/df) ;
int iStop=(int)(fStop/df) ;

int nPoints1=11*nPoints ;

float[] trace1=new float[nPoints1] ;
float[] trace2=new float[nPoints1] ;
float[] trace2meanYY=new float[nPoints1] ;
float[] trace2max=new float[nPoints1] ;

int shiftAmount ;

Minim minim;

AudioStream input ;
MultiChannelBuffer buffer; 
int iGet=Integer.MAX_VALUE ;
float LL=0 ;
float RR=0 ;

void getLLRR(){
  if(iGet>=buffer.getBufferSize()){ 
    iGet=0 ;
    input.read(buffer) ;
    }
  RR=buffer.getSample(0,iGet) ;
  LL=buffer.getSample(1,iGet) ;
  iGet++ ;
  }
  
void clear(){
  for (int k=0; k<nPoints; k++) {
    trace2meanYY[k]=0.0 ;
    trace2max[k]=0.0 ;
    trace1[k]=0.0 ;
    }
  }
  
float theWindowFactor ; 


AudioOutput out;
Oscil       wave;


void setup() {
  //size(1400+1200, 900);
  size(1200, 900);
  
  // abort() ;

   if(fStart<0) { fStart=0 ; }
   if (fStop>fSample/2) { fStop=fSample/2 ; }
        
  PFont font;
  //font = createFont("Lucida Console", 12);
 // font = createFont("Monospaced.plain", 12);
  font = createFont("Monospaced.bold", 12);
  textFont(font);

  println(String.format("fSample=%12.3f kHz",fSample/kHz)) ;
  println("iStart="+iStart+"  iStop="+iStop) ;
  println("fStart="+fStart+"  fStop="+fStop) ;
  for (int k=0; k<nPoints; k++) {
    trace1[k]=0 ;
    trace2[k]=0 ;
    trace2meanYY[k]=0.0 ;
    trace2max[k]=0.0 ;
    }
  minim = new Minim(this);
  //input=minim.getInputStream(Minim.STEREO,2048,44100,16) ; // 
  input=minim.getInputStream(Minim.STEREO,2048,fSample,16) ; // 
  input.open() ;
  buffer= new MultiChannelBuffer(1024, input.getFormat().getChannels());
  println("buffer.getChannelCount()="+buffer.getChannelCount()) ;
  println("buffer.getBufferSize()="+buffer.getBufferSize() ) ;
  
  theWindowFactor=FFThelp.getWindowFactor(nPoints) ;
  println("theWindowFactor=",theWindowFactor) ;
  
  if(withSigGen){
    print("withSigGen") ;
    println("siggen Frq=",sigGenFrq) ;
    int nn=2*nSamples ;
    out = minim.getLineOut(minim.STEREO,nn,fSample,16);
    float sampleRate=out.sampleRate() ;
    println("out.sampleRate=",sampleRate) ;
    int bufferSize=out.bufferSize() ;
    println("out.bufferSize=",bufferSize) ;
    //wave = new Oscil( frq0, 1.0f, Waves.SINE );
    // sigGenAmpl=1 delivers sine Upp=1.4V Urms=1.4V/2/sqrt(2)=0.5 Vrms
    wave = new Oscil( (float)sigGenFrq, sigGenAmplRms*2, Waves.SINE );
    // patch the Oscil to the output
    wave.patch( out );
    }
  }

float REFlevel(float f) {
  return  REFlevel1(f) ;  
  }

float REFlevel1(float f) {
  //return filterGain(f) ;
  return sqrt(1.0/100.0) ;
  }
 
float getSample(int k){
  getLLRR() ;
  return LL ;
  }
  
 //*************************************************************************************************** 
 
void dottedLine(int x0, int y0, int x1, int y1){
  float length=sqrt(sqr(x1-x0)+sqr(y1-y0)) ;
  int nSegments=(int)(length/20.0) ;
  for(int k=0 ; k<nSegments ; k++){
    int xA=(int)linMap((float)0,(float)nSegments,(float)x0,(float)x1,k) ;
    int yA=(int)linMap((float)0,(float)nSegments,(float)y0,(float)y1,k) ;
    int xB=(int)linMap((float)0,(float)nSegments,(float)x0,(float)x1,k+0.2) ;
    int yB=(int)linMap((float)0,(float)nSegments,(float)y0,(float)y1,k+0.2) ;
    line(xA,yA,xB,yB) ;
    }
  }

float sqr(float x) { return x*x ; }
float log10(float x) { return log(x)/log(10.0) ; }    
float dBfun(float y, float ref) { return 20*log10(y/ref) ; }

float mW=1e-3 ;
float xRref=50 ;
float xPref=1*mW ;
  
float UrmsTodBm(float Urms){
  float P=(float)sqr(Urms)/xRref ;
  return 10*log10((float)(P/xPref)) ;
  }  

float dBmToUrms(float dBm){
  float P=xPref*pow(10.0,(dBm/10.0)) ;
  return sqrt(P*xRref) ;
  }

float UpkTodBm(float Upk){
  float Urms=Upk/sqrt(2) ;
  return UrmsTodBm(Urms) ;
  }  
  
float UppTodBm(float Upp){
  float Urms=Upp/2.0/sqrt(2) ;
  return UrmsTodBm(Urms) ;
  }  
    
//------------------------------------------------------------------------ 


float power(float x, float y) {
  return exp(y*log(x)) ;
  }

float linMap(float x1, float x2, float y1, float y2, float x) {
  return(y1+(x-x1)/(x2-x1)*(y2-y1)) ;
  }
  
float logMap(float x1, float x2, float y1, float y2, float x) {
 // println("xMap("+x1+" "+x2+" "+y1+" "+y2+" "+x) ;
 // print("log10(x2)-log10(x1)="+(log10(x2)-log10(x1)));
  return(y1+(log10(x)-log10(x1))/(log10(x2)-log10(x1))*(y2-y1)) ;
  }
  
float xMap(float x1, float x2, float y1, float y2, float x) {
  return linMap(x1, x2, y1, y2, x) ;
  //return logMap(x1, x2, y1, y2, x) ;
  }

int yScaled(float y){
  float y1=y ;
  if( y1<dBmin ) { y1=dBmin ; }
  if( y1>dBmax) { y1=dBmax ; }
  return (int) linMap(dBmin, dBmax, dftFrameY0, dftFrameY1, y1) ;
  }

int scaledBmTrace(float y) {
  float  y1=UpkTodBm(y) ;
  if( y1<dBmin ) { y1=dBmin ; }
  if( y1>dBmax) { y1=dBmax ; }
  return (int) linMap(dBmin, dBmax, dftFrameY0, dftFrameY1, y1) ;
  }

int scaleTrace1(float y) {
  if( y<yMin ) { y=yMin ; }
  if (y>yMax ) { y=yMax ; }
  return (int) linMap(yMin, yMax, ykFrameY0, ykFrameY1, y) ;  
  }

void showTimeSignal(float[] trace, float scale, float dy){
  strokeWeight(1) ;
  for (int xk=xMin+1 ; xk<xMax ; xk++) {
    int x1=(int)(linMap(xMin, xMax ,  ykFrameX0,  ykFrameX1, xk-1)) ;
    int x2=(int)(linMap(xMin, xMax ,  ykFrameX0,  ykFrameX1, xk)) ;
    int a1=(int)dy+(int) scaleTrace1(scale*trace[xk-1]) ;
    int a2=(int)dy+(int) scaleTrace1(scale*trace[xk]) ;
   // println("k="+xk+" trace="+trace[xk]) ;
   // println("line("+x1+","+a1+","+x2+","+a2+")") ;
    line(x1, a1, x2, a2) ;
    }
  }
  
  
void showTimeSignalAC(float[] trace, float scale, float dy){
  float mean=0.0 ;
  for(int k=0 ; k<nPoints ; k++){ mean+=trace[k] ; }
  mean=mean/nPoints ;
  strokeWeight(1) ;
  for (int xk=xMin+1 ; xk<xMax ; xk++) {
    int x1=(int)(linMap(xMin, xMax ,  ykFrameX0,  ykFrameX1, xk-1)) ;
    int x2=(int)(linMap(xMin, xMax ,  ykFrameX0,  ykFrameX1, xk)) ;
    int a1=(int)dy+(int) scaleTrace1(scale*(trace[xk-1]-mean)) ;
    int a2=(int)dy+(int) scaleTrace1(scale*(trace[xk]-mean)) ;
   // println("k="+xk+" trace="+trace[xk]) ;
   // println("line("+x1+","+a1+","+x2+","+a2+")") ;
    line(x1, a1, x2, a2) ;
    }
  }      


int yline ;

void abort(){
  println("abort() !") ;
  while(true){}
  }
  
int k=0 ;  
  int run=0 ;
  String line1="what ?" ;
  String line2="what ?" ;
  boolean overflow=false ;
 
  float bufVpp=1 ;
  
void oneMeasurement() {
  //println("oneMeasurement k="+k++) ;
  float Vrms1 ;
  float VdB ;
  float bufMax=-1e10;
  float bufMin=1e10 ;
  overflow=false ;
  println("timefun analyze") ;
  for (int k=0; k<nPoints; k++) {
    float v=getSample(k) ;
//    v=0.145*cos(2*PI*k*2000.0/fSample) ;
//    v=0.145*cos(2*PI*k*1.0/32.0) ;
      
    if(v>0.95){ overflow=true ; }
    if(v<-0.95){ overflow=true ; }
    
    v=v*inputScale ;
  
  if(v>bufMax){ bufMax=(float)v ; }
    if(v<bufMin){ bufMin=(float)v ; }
  
    // 0.5Vpk=-2dBm
   // v=v*0.34 ;
    
  
    //v=0.1* (int)(1000*cos(2*PI*k*1.0/64))/1000.0 ; ;
    trace1[k]=v ;
    }
  bufVpp=bufMax-bufMin ;
  //line1=String.format("bufMax=%6.4f V bufMin=%6.4f V Vpp=%6.4f",bufMax,bufMin,bufVpp) ;
  line1=String.format("inpVpp=%6.4f mV ",bufVpp/mV) ;  
  line2="" ;
  println("bufMin=",bufMin," bufMax=",bufMax,"   bufVpp=",bufVpp) ;
  Vrms1=bufVpp/2.0/sqrt(2.0) ;
  VdB=UrmsTodBm(Vrms1) ;
  println("from Vpp Vrms=",Vrms1,"  = ",VdB," dBm") ;
  if(overflow){ 
    println("********************************************* OVERFLOW !") ;
    }    
  
  float re[]=new float[nPoints] ;
  float im[]=new float[nPoints] ;
  float inputSqSum=0.0 ;
  float reMax=-1e10 ;
  float reMin=1e10 ;
  
  for (int k=0; k<nPoints; k++) {
    float uu=(float) trace1[k] ;
    re[k]=uu ;
    im[k]=0.0 ;
    inputSqSum+=sqr(re[k])+sqr(im[k]) ;
    if(uu>reMax){ reMax=uu ; }
    if(uu<reMin){ reMin=uu ; }
    }
  println("reMin=",reMin," reMax=",reMax) ;
  
  inputSqSum=sqrt(inputSqSum/nPoints) ;
  println(" inputRMSbySum="+inputSqSum+" ") ;
  println("end timefun analyze") ; 
  float scale1=sqrt(1.0/nPoints) ;
  scale1=2.0/nPoints ;
  if(withWindow){
    println("here theWindowFactor=",theWindowFactor) ;
    FFThelp.windowed(nPoints, 1, scale1/theWindowFactor , re, im) ;
    }
   else{
    // FFThelp.fft(nPoints, 1, scale1/inputFactor , re, im) ;
    FFThelp.fft(nPoints, 1, scale1 , re, im) ;
    }
 
  float outputSqSum=0.0 ;
  for (int k=0; k<nPoints; k++) { outputSqSum+=sqr(re[k])+sqr(im[k]) ; }
  outputSqSum=sqrt(outputSqSum/nPoints) ;
  float amplitude=0 ;
  maxVal=0 ;
  for (int k=iStart; k<iStop ; k++) {
    amplitude=sqrt(sqr(re[k])+sqr(im[k])) ;
    trace2[k]=amplitude ;
    trace2meanYY[k]=0.9*trace2meanYY[k]+0.1*sqr(amplitude) ; 
    if(k<nPoints/2){
      // if(trace2meanYY[k]>maxVal){ maxIndex=k ; maxVal=trace2meanYY[k] ; amplMax=amplitude ;}
      if(trace2[k]>maxVal){ maxIndex=k ; maxVal=trace2[k] ; }
      }
    if (trace2[k]>trace2max[k]) { trace2max[k]=trace2[k] ; }
    }
  println() ;
  println("max=",maxVal) ;
  println(" Urms(50Ohm) axIndex=",maxIndex) ;
  println("run=",run++) ;
  if(fCursor>0){ 
    cursorValPk=0 ;
    cursorIndex=(int)(fCursor/fSample*nPoints) ;
    cursorIndex2=0 ;
    println("cursorIndex =",cursorIndex) ;
    for (int k=cursorIndex-3; k<cursorIndex+3 ; k++) {
        if(trace2[k]>cursorValPk){ cursorIndex2=k ; cursorValPk=trace2[k] ; }
        }
    println("cursorIndex2=",cursorIndex2) ;
    println("cursorValPk=",cursorValPk) ;
    }
  //if(run>200){ save("spec2.png") ; abort() ; }
  
  float maxValdBm= (float) UpkTodBm((float)maxVal) ;
  println("maxIndex=",maxIndex," max=",maxVal," Vrms  ",maxValdBm," dBm(50Ohm)") ;
  float FFkHz=(float)(fSample*maxIndex/(float) nPoints/kHz) ;
  println("frq=",FFkHz," kHz") ;
  String ss1=String.format(" maxVal=%6.4f mVpk = %4.2f dBm at f=%8.3f kHz",maxVal/mV,maxValdBm,FFkHz)    ;
  
  float cursordBm= (float) UpkTodBm(cursorValPk) ;
  float cursorValRms=cursorValPk/sqrt(2) ;
  float CCkHz=(float)(fSample*cursorIndex2/(float) nPoints/kHz) ;
  String ss2=String.format(" cursor frq=%8.3f kHz Urms= %6.4f mV = %6.4f dBm(50Ohm)",CCkHz,cursorValRms/mV,cursordBm) ;
  bufVpp=(float)maxVal*2.0 ;
  println("YYY bufVpp=",bufVpp) ;
  line1=line1+ss1 ;
  line2=line2+ss2 ;
  println("ss1=",ss1) ;
//  text(ss,200,210) ;
 // delay(500) ;
//  for(int k=maxIndex-5 ; k<maxIndex+5 ; k++){
//    println("k-maxIndex=",k-maxIndex,"  ",sqrt(sqr(re[k])+sqr(im[k]))," =?=",trace2[k]) ;
//    }
  }
  
 int kRun=0 ;
  
void draw(){ 
 // background(200);
 // delay(1000) ;
  int x1,x2,x3,y1,y2,y3 ;
  int xx,yy;
  println() ;
  println("start draw()") ;
  println("fSample=",fSample) ;
  println("FFT df=",df) ;
  oneMeasurement() ;
  
  stroke(255, 0, 0);
  
  textSize((int)(16))  ;
  fill(0, 0, 0) ;
  
  int SizeX=displaySizeX ;
  if (SizeX<nPoints) { SizeX=nPoints ; }
  
  fill(250, 250, 200);
  rect( dftFrameX1, dftFrameY1, dftFrameX0-dftFrameX1 , dftFrameY0-dftFrameY1) ;
  
  strokeWeight(2) ;
  float fm ; int xm ;
  //fm=fTX-fShift/2 ; int xm=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,fm) ; dottedLine(xm,dftFrameY0 ,xm,dftFrameY1) ;
  //fm=fTX+fShift/2 ; xm=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,fm) ; dottedLine(xm,dftFrameY0 ,xm,dftFrameY1) ;
//  fm=fCursor-100 ; xm=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,fm) ; dottedLine(xm,dftFrameY0 ,xm,dftFrameY1) ;
//  fm=fCursor+100 ; xm=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,fm) ; dottedLine(xm,dftFrameY0 ,xm,dftFrameY1) ;
   stroke(0,0,0) ;
   fill(0,0,0) ;

   fm=fCursor ; xm=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,fm) ; dottedLine(xm,dftFrameY0 ,xm,dftFrameY1) ;
 
/*   fm=fCursor+77500.0/120.0 ; xm=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,fm) ; dottedLine(xm,dftFrameY0 ,xm,dftFrameY1) ;
   text(" +646Hz",xm-30,dftFrameY1-10) ;
   fm=fCursor-77500.0/120.0 ; xm=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,fm) ; dottedLine(xm,dftFrameY0 ,xm,dftFrameY1) ;
   text(" -646Hz",xm-30,dftFrameY1-10) ;
*/   
  fill(0, 0, 0);
  stroke(150);
  int y ;
  //y=(int)(scaledBmTrace(100)) ;   line(dftFrameX0, y, dftFrameX1, y) ; text("+40dB",dftFrameX0,y-5) ;
 //  y=(int)(scaledBmTrace(10)) ;   line(dftFrameX0, y, dftFrameX1, y) ; text("+20dB",dftFrameX0,y-5) ;
   y=(int)(yScaled(10)) ;  line(dftFrameX0, y, dftFrameX1, y) ; text("  10",dftFrameX0-50,y+4) ;
   y=(int)(yScaled(0)) ;  line(dftFrameX0, y, dftFrameX1, y) ; text("  0",dftFrameX0-50,y+4) ;
//   y=(int)(yScaled(    -2)) ;  line(dftFrameX0, y, dftFrameX1, y) ; text("  -2",dftFrameX0-50,y+4) ;
     
   y=(int)(yScaled(-10)) ;  line(dftFrameX0, y, dftFrameX1, y) ; text(" -10",dftFrameX0-50,y+4) ;
   y=(int)(yScaled(-20)) ;  line(dftFrameX0, y, dftFrameX1, y) ; text(" -20",dftFrameX0-50,y+4) ;
   y=(int)(yScaled(-30)) ;  line(dftFrameX0, y, dftFrameX1, y) ; text(" -30",dftFrameX0-50,y+4) ;
   y=(int)(yScaled(-40)) ;  line(dftFrameX0, y, dftFrameX1, y) ; text(" -40",dftFrameX0-50,y+4) ;
   y=(int)(yScaled(-60)) ;  line(dftFrameX0, y, dftFrameX1, y) ; text(" -60",dftFrameX0-50,y+4) ;
   y=(int)(yScaled(-80)) ;  line(dftFrameX0, y, dftFrameX1, y) ; text(" -80",dftFrameX0-50,y+4) ;
   y=(int)(yScaled(-100)) ;  line(dftFrameX0, y, dftFrameX1, y) ; text("-100",dftFrameX0-50,y+4) ;
     
   
 // y=(int)(scaledBmTrace(1.0/10)) ;   line(dftFrameX0, y, dftFrameX1, y) ; text("-20dB",dftFrameX0,y-5) ;
 // y=(int)(scaledBmTrace(1.0/100)) ;  line(dftFrameX0, y, dftFrameX1, y) ; text("-40dB",dftFrameX0,y-5) ;
 // y=(int)(scaledBmTrace(1.0/1000)) ; line(dftFrameX0, y, dftFrameX1, y) ; text("-60dB",dftFrameX0,y-5) ;
 // y=(int)(scaledBmTrace(1.0/10000)) ; line(dftFrameX0, y, dftFrameX1, y) ; text("-80dB",dftFrameX0,y-5) ;
 // y=(int)(scaledBmTrace(1.0/100000)) ; line(dftFrameX0, y, dftFrameX1, y) ; text("-90dB",dftFrameX0,y-5) ;

//  text( "  black: new measurement, red: mean measurement,   blue: maxhold measurement ",dftFrameX0,680) ;


  
  stroke(0, 0, 0);
/* 
  float yMin1=trace1[xMin ];
  float yMax1=trace1[xMin ];
  for (int xk=xMin+1 ; xk<xMax ; xk++) {
    float yy1=trace1[xk] ;
    if(yy1>yMax1) { yMax1=yy1 ; }
    if(yy1<yMin1) { yMin1=yy1 ; }
    }
  if(autoScaleY){
    yMin=yMin1 ;
    yMax=yMax1 ;
    }
// println("Umin="+yMin1+" Umax="+yMax1) ;
*/    
  fill(250, 250, 200);
  rect( ykFrameX1, ykFrameY1, ykFrameX0-ykFrameX1 , ykFrameY0-ykFrameY1) ;

/*
  fill(0,0,0) ;
  stroke(250,0,0) ;
  strokeWeight(3) ;
  float ssA=2000*traceScaleA ;
  showTimeSignalAC(trace1,ssA,0) ;
  //showTimeSignal(trace1B,100,20) ;
*/     
  stroke(100,100,100) ;
  float f00=2e3 ;
  //bufVpp=0.5 ;
  println("XXX bufVpp=",bufVpp) ;
  
  float bk=bufVpp/2 ;
 // int xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,1*f00) ; int yy=(int)(yScaled((float)UpkTodBm(bk))) ; xcircle2(xx,yy,10) ;
 
   f00=f00 ; 
   k=1 ; bk=bufVpp/k*2/PI ;
 // int xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,1*f00) ; int yy=(int)(yScaled((float)UpkTodBm(bk))) ; xcircle1(xx,yy,10) ;
  
  k=3 ; bk=bufVpp/k*2/PI ;
  // xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,3*f00) ; yy=(int)(yScaled((float)UpkTodBm(bk))) ; xcircle1(xx,yy,10) ;
  
  k=5 ; bk=bufVpp/k*2/PI ;
  // xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,5*f00) ; yy=(int)(yScaled((float)UpkTodBm(bk))) ; xcircle1(xx,yy,10) ;
  
  k=7 ; bk=bufVpp/k*2/PI ;
  // xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,7*f00) ; yy=(int)(yScaled((float)UpkTodBm(bk))) ; xcircle1(xx,yy,10) ;
  
  
  /*
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,5e6) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text("     5M",xx-60,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,2e6) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text("     2M",xx-60,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,1e6) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text("     1M",xx-60,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,500e3) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text("  500k",xx-60,dftFrameY1-10) ;
 */
  strokeWeight(3) ;
  
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,77.5e3) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text(" 77.5k",xx-30,dftFrameY1-10) ;

/*
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,80e3) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;  
  text(" 80k",xx-30,dftFrameY1-10) ;
      
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,75e3) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text(" 75k",xx-30,dftFrameY1-10) ;
*/   

  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,50e3) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text(" 50k",xx-30,dftFrameY1-10) ;
  
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,20e3) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text(" 20k",xx-30,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,10e3) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;  
  text(" 10k",xx-30,dftFrameY1-10) ;
      
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,5e3) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text(" 5k",xx-20,dftFrameY1-10) ;
     
 // xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,2e3) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
 // text(" 2k",xx-30,dftFrameY1-10) ;
    
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,1e3) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;  
  text(" 1k",xx-20,dftFrameY1-10) ;
  /*          
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,500) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text("500Hz",xx-30,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,200) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text("200Hz",xx-30,dftFrameY1-10) ;
   
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,100) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;  
  text("100Hz",xx-30,dftFrameY1-10) ;
          
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,50) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text(" 50Hz",xx-30,dftFrameY1-10) ;
    
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,20) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;
  text(" 20Hz",xx-30,dftFrameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,10) ; dottedLine(xx,dftFrameY0 ,xx,dftFrameY1) ;  
  text(" 10Hz",xx-30,dftFrameY1-10) ;
  */          
  
    text("UdBm",10,50) ;
    text("(50Ohm)",10,75) ;    
  stroke(0,0,0) ;
  strokeWeight(2) ;
  //  xx=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,fSample*filter1fg) ;
  // line(xx,dftFrameY0 ,xx,dftFrameY1) ;
   strokeWeight(1) ;
    

  if(showmax){ 
    stroke(0, 0, 255) ;  
    for (int k=1; k<nPoints/2; k++) {    
      x1=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,(k-1)*df) ;
      x2=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,k*df) ;
      y1=(int)(scaledBmTrace(trace2max[k-1])) ;
      y2=(int)(scaledBmTrace(trace2max[k])) ;
      line(x1, y1, x2, y2) ;    
      }
    }
    
  if(show){ 
    strokeWeight(1) ;
    //stroke(195, 5, 45);
    //stroke(100,100,100);
    stroke(0,0,0);
   println("hello iStart=",iStart," iStop= ",iStop) ;
    for (int k=iStart+1; k<iStop ; k++) {    
      x1=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,(k-1)*df) ;
      x2=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,k*df) ;
      y1=(int)(scaledBmTrace(trace2[k-1])) ;
      y2=(int)(scaledBmTrace(trace2[k])) ;
      /*
      if( abs(k-maxIndex)<5) {
        println("k=",k," trace2=",trace2[k]," UpkTodBm(trace2[k])=",UpkTodBm(trace2[k])) ;
        }
      */
      line(x1, y1, x2, y2) ;
      }
    }

//  stroke(255,255,255) ;  
  if(showmean){
    if(maxIndex>0){
      x2=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,maxIndex*df) ;
      y2=(int)(scaledBmTrace(sqrt(trace2meanYY[maxIndex]))) ;
     
      x1=x2-10 ;
      y1=(int)(scaledBmTrace(0.8*sqrt(trace2meanYY[maxIndex]))) ;
   
      x3=x2+10 ;
      y3=(int)(scaledBmTrace(0.8*sqrt(trace2meanYY[maxIndex]))) ;
      triangle(x1,y1,x2,y2,x3,y3) ;
     // println("triangle "+x1+" "+y1+" "+x2+" "+y2+" "+x3+" "+y3) ;
      }
    //stroke(9,90 ,90) ;
    stroke(255,0 ,0) ; 
    strokeWeight(2) ;
    if(true){
      for (int k=iStart; k<iStop; k++) {    
        x1=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,(k-1)*df) ;
        x2=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,k*df) ;
        y1=-100+(int)(scaledBmTrace(sqrt(trace2meanYY[k-1]))) ;
        y2=-100+(int)(scaledBmTrace(sqrt(trace2meanYY[k]))) ;
        //  if(k<10){println("showmean showtrace2meanYY k="+k+" val="+trace2meanYY[k]/meanCount); }
        line(x1, y1, x2, y2) ;
        }
      stroke(255, 0, 0) ;
      }
    }
  
     println("maxIndex=",maxIndex) ;
      strokeWeight(3) ;
      stroke(255,0,255) ;
       int xx2=(int)xMap(fStart,fStop,dftFrameX0,dftFrameX1,maxIndex*df) ;
       //y2=(int)(scaledBmTrace(sqrt(trace2[k]))) ;
       y2=(int)(scaledBmTrace(trace2[maxIndex])) ;
          
  fill(0,0,0) ;   
  text(line1,400,100) ;
  text(line2,400,150) ;
  if(overflow){ text("overflow !",400,250) ; }
    
  strokeWeight(1) ;  
  yline++ ; if(yline>300) { yline=0 ; }
  
  fill(0,0,0) ;
  stroke(250,0,0) ;
  strokeWeight(3) ;
  float ssA=2000*traceScaleA ;
  showTimeSignalAC(trace1,ssA,0) ;
   
   /*
   kRun++ ;
   String tt=String.format("spec%d.png",kRun) ;
   if(  (20<kRun) & (kRun<40)){ 
     save(tt) ; 
     println("save tt='",tt,"'") ;
     }
  if(kRun>40){ System.exit(2) ; }
  */
  
  /*
  if(mousePressed){
    delay(250) ;
    save("spec1.png") ;
    println("save spec1.png") ;
   while(true){ delay(1) ; }
    //delay(2500) ;
    }
  */  
  }

void error(String s) {
  println() ;
  println("Error:"+s) ;
  System.exit(1) ;
  }


int maxIndex ;
float maxVal ;
int cursorIndex=0 ;
int cursorIndex2=0 ;
float cursorValPk=0 ;

    
float M_PI=PI ;   
  
class FFThelper{
   
  void error(String s){
  System.out.println() ;
  System.out.println("Error:"+s) ;
  System.exit(1) ;
  }


float pi=PI ;
  
  float sqr(float x){
  return x*x ;  
    }
  float ln(float x){
  return log(x) ;  
    }
    
  float log10(float x){
  return log(x)/log(10.0) ;  
    }    
    
  float dBfun(float y, float ref){
    return 20*log10(y/ref) ;
    }
  
  int round(float x){
  return (int)(x+0.5) ;  
    }
  
  float frac(float x){
  return x-round(x) ;
    }    
    
    
 float windowFun(int nn, int k){
      //float w=0.54-0.46*cos(2*PI*k/(n-1)) ;
      //float w=0.5-0.5*cos(2*PI*k/(n-1)) ;
    float w=1.0 ;
    float alpha=0.16 ;
    float a0=(1-alpha)/2 ;
    float a1=0.5 ;
    float a2=alpha/2 ;
    w=a0-a1*cos(2*PI*k/(nn-1))+a2*cos(4*PI*k/(nn-1)) ;
    return w ;  
    }
    
    
 void windowed(int n, int flag , float scale , float[]tor, float[] toi){
  for(int k=0 ; k<n ; k++){
    float w=windowFun(n,k) ;    //  w=1.0 ;
    tor[k]=tor[k]*w;
    }
  fft(n,flag ,scale ,tor,toi) ;
  }
    
    
  float dsqrt(float x){
    return (float) sqrt((float)x) ; 
    }
  
  float getWindowFactor(int nSamples){
    int mm=64 ;
    float sigRe[]=new float[nSamples] ;
    float sigIm[]=new float[nSamples] ;
    for (int k=0; k<nSamples; k++) {
      sigRe[k]=cos(2*PI*k*mm/nSamples)*windowFun(nSamples,k) ; ;
      sigIm[k]=0 ;
      }
    float  scale1=2.0/nSamples ;
    FFThelp.fft(nSamples, 1, scale1 , sigRe, sigIm) ;
    println("fftRe[mm]=",sigRe[mm]," fftIm[mm]=",sigIm[mm]) ;
    float ff=(float) sigRe[mm] ;
    println("windowFactor=",ff) ;
    //stop() ;
    return ff ; 
    }    
  
  void fft(int n, int flag , float scale , float[]tor, float[] toi) {
    //{ switch to DFT procedure if N not power of 2 }
  //for(int k=0 ; k<n ; k++) {
  //  System.out.println(String.format(" input re/im = %10.5f +im %10.5f",tor[k],toi[k])) ;
  //  }    
    int j,k,l,m,m1,n1,r,r1,r2 ;
    float re,im,a,b,ru,rv,iu,iv,rs ;
    float check ;
    check=frac(ln(n)/ln(2)+1.0e-5) ;
    //System.out.println("check="+check) ;
    if ( abs(check)>1.0e-4 ){
      // write('SWITCHED to DFT') ;}
      // writeln('check=',check,' n=',n) ; readln ; halt ;
      error("cant switch to dft n="+n);
      System.exit(1) ;
      //dft(n,flag,scale,tor,toi) ;
      }
     else{
     m1=n / 2 ;
     n1=round(ln(n)/ln(2)) ;
     
     //System.out.println(" n="+n+" n1="+n1) ;
     
     l=0 ;
     for ( k=0 ; k<n ; k++){
       if ( k>l ) { 
         re=tor[l] ; 
         im=toi[l] ; 
         tor[l]=tor[k] ; 
         toi[l]=toi[k] ;
         tor[k]=re ; 
         toi[k]=im ;
         }
       j=m1 ;
       while( (j<=l) & (j>0) ){  l=l-j ; j=j / 2 ; }
       l=l+j ;
       }
     m1=1 ;
     for ( m=1 ; m<=n1 ; m++){
       a=cos(pi/m1) ; 
       b=flag*sin(pi/m1) ; 
       re=1 ; 
       im=0 ;
       for ( j=0 ; j<m1 ; j++){
       r=0 ;
        while ( r<=n-1 ){ 
        r1=r+j ; r2=r1+m1 ;
        ru=tor[r1] ; iu=toi[r1] ;
        rv=tor[r2]*re-toi[r2]*im ;
        iv=tor[r2]*im+toi[r2]*re ;
        tor[r1]=ru+rv ; toi[r1]=iu+iv ;
        tor[r2]=ru-rv ; toi[r2]=iu-iv ;
        r=r+2*m1 ;
        }
      rs=a*re-b*im ; 
      im=a*im+b*re ;
      re=rs ;
      }
    m1=2*m1 ;
    }
    for( k=0 ; k<n ; k++) {
      tor[k]=scale*tor[k] ; 
      toi[k]=scale*toi[k] ;
      //System.out.println(String.format(" re/im = %10.5f +im %10.5f",tor[k],toi[k])) ;
      }
    }
  }
}  
