
 //*************************************************************************************************** 
 
void dottedLine(int x0, int y0, int x1, int y1){
  float length=sqrt(sqr(x1-x0)+sqr(y1-y0)) ;
  int nSegments=(int)(length/20.0) ;
  for(int k=0 ; k<nSegments ; k++){
    int xA=(int)linMap((float)0,(float)nSegments,(float)x0,(float)x1,k) ;
    int yA=(int)linMap((float)0,(float)nSegments,(float)y0,(float)y1,k) ;
    int xB=(int)linMap((float)0,(float)nSegments,(float)x0,(float)x1,k+0.2) ;
    int yB=(int)linMap((float)0,(float)nSegments,(float)y0,(float)y1,k+0.2) ;
    line(xA,yA,xB,yB) ;
    }
  }
  

float sqr(float x) { return x*x ; }
float dBfun(float y, float ref) { return 20*log10(y/ref) ; }
float log10(float x) { return log(x)/log(10) ; }

float mW=1e-3 ;
float xRref=50 ;
float xPref=1*mW ;
  
float UrmsTodBm(float Urms){
  float P=(float)sqr(Urms)/xRref ;
  return 10*log10((float)(P/xPref)) ;
  }  

float dBmToUrms(float dBm){
  float P=xPref*pow(10.0,(dBm/10.0)) ;
  return sqrt(P*xRref) ;
  }

/*
float UpkTodBm(float Upk){
  float Urms=Upk/sqrt(2) ;
  float P=sqr(Urms)/xRref ;
  return 10*log10((float)(P/xPref)) ;
  }  
*/

//------------------------------------------------------------------------ 

float power(float x, float y) {
  return exp(y*log(x)) ;
  }

float linMap(float x1, float x2, float y1, float y2, float x) {
  return(y1+(x-x1)/(x2-x1)*(y2-y1)) ;
  }
  
float logMap(float x1, float x2, float y1, float y2, float x) {
 // println("xMap("+x1+" "+x2+" "+y1+" "+y2+" "+x) ;
 // print("log10(x2)-log10(x1)="+(log10(x2)-log10(x1)));
  return(y1+(log10(x)-log10(x1))/(log10(x2)-log10(x1))*(y2-y1)) ;
  }
  
float xMap(float x1, float x2, float y1, float y2, float x) {
  //return linMap(x1, x2, y1, y2, x) ;
  return logMap(x1, x2, y1, y2, x) ;
  }

int yScaled(float y){
  float y1=y ;
  if( y1<dBmin ) { y1=dBmin ; }
  if( y1>dBmax) { y1=dBmax ; }
  int yy=(int) linMap(dBmin, dBmax, frameY0, frameY1, y1) ;
//  println("yScaled(",y,")  =  ",yy) ;
  return yy ;
  }

int scaledBmTrace(float y) {
  float y1=dBfun(y, 1.0) ;
  if( y1<dBmin ) { y1=dBmin ; }
  if( y1>dBmax) { y1=dBmax ; }
  int yy=(int) linMap(dBmin, dBmax, frameY0, frameY1, y1) ;
//  println("scaledBmTrace(",y,")  dB=",y1," yy=  ",yy) ;
  return yy ;
  }

int yline ;

void abort(){
  println("abort() !") ;
  while(true){}
  }
  
void error(String s) {
  println() ;
  println("Error:"+s) ;
  System.exit(1) ;
  }
  
void draw(){ 
  int x1,x2,x3,y1,y2,y3 ;
  int xx,yy;
  stroke(255, 0, 0);
  
  textSize((int)(16))  ;
   
  fill(250, 250, 200);
  rect( frameX1, frameY1, frameX0-frameX1 , frameY0-frameY1) ;
  
  strokeWeight(2) ;
  float fm ; int xm ;
 
  stroke(0,0,0) ;
   fm=fCursor ; xm=(int)xMap(fStart,fStop,frameX0,frameX1,fm) ; dottedLine(xm,frameY0 ,xm,frameY1) ;
 //  fm=fCursor+77500.0/120.0 ; xm=(int)xMap(fStart,fStop,frameX0,frameX1,fm) ; dottedLine(xm,frameY0 ,xm,frameY1) ;
//   fm=fCursor-77500.0/120.0 ; xm=(int)xMap(fStart,fStop,frameX0,frameX1,fm) ; dottedLine(xm,frameY0 ,xm,frameY1) ; 
   
  fill(0, 0, 0);
  stroke(150);
  text(" dB",frameX0-50,80) ;
  
  int y ;
   y=(int)(yScaled(40)) ;  line(frameX0, y, frameX1, y) ; text("  40",frameX0-50,y+4) ;
   y=(int)(yScaled(20)) ;  line(frameX0, y, frameX1, y) ; text("  20",frameX0-50,y+4) ;
   y=(int)(yScaled(10)) ;  line(frameX0, y, frameX1, y) ; text("  10",frameX0-50,y+4) ;
   y=(int)(yScaled(0)) ;  line(frameX0, y, frameX1, y) ; text("  0",frameX0-50,y+4) ;
   y=(int)(yScaled(-10)) ;  line(frameX0, y, frameX1, y) ; text(" -10",frameX0-50,y+4) ;
   y=(int)(yScaled(-20)) ;  line(frameX0, y, frameX1, y) ; text(" -20",frameX0-50,y+4) ;
   y=(int)(yScaled(-30)) ;  line(frameX0, y, frameX1, y) ; text(" -30",frameX0-50,y+4) ;
   y=(int)(yScaled(-40)) ;  line(frameX0, y, frameX1, y) ; text(" -40",frameX0-50,y+4) ;
   y=(int)(yScaled(-60)) ;  line(frameX0, y, frameX1, y) ; text(" -60",frameX0-50,y+4) ;
   y=(int)(yScaled(-80)) ;  line(frameX0, y, frameX1, y) ; text(" -80",frameX0-50,y+4) ;
   y=(int)(yScaled(-100)) ;  line(frameX0, y, frameX1, y) ; text("-100",frameX0-50,y+4) ;

  fill(0,0,0) ;
  stroke(100,100,100) ;

  strokeWeight(2) ;
  xx=(int)xMap(fStart,fStop,frameX0,frameX1,80e3) ; dottedLine(xx,frameY0 ,xx,frameY1) ;  
  text(" 80k",xx-30,frameY1-10) ;
    
  xx=(int)xMap(fStart,fStop,frameX0,frameX1,20e3) ; dottedLine(xx,frameY0 ,xx,frameY1) ;
  text(" 20k",xx-30,frameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,frameX0,frameX1,10e3) ; dottedLine(xx,frameY0 ,xx,frameY1) ;  
  text(" 10k",xx-30,frameY1-10) ;
      
  xx=(int)xMap(fStart,fStop,frameX0,frameX1,5e3) ; dottedLine(xx,frameY0 ,xx,frameY1) ;
  text(" 5k",xx-20,frameY1-10) ;
     
  xx=(int)xMap(fStart,fStop,frameX0,frameX1,2e3) ; dottedLine(xx,frameY0 ,xx,frameY1) ;
  text(" 2k",xx-30,frameY1-10) ;
    
  xx=(int)xMap(fStart,fStop,frameX0,frameX1,1e3) ; dottedLine(xx,frameY0 ,xx,frameY1) ;  
  text(" 1k",xx-20,frameY1-10) ;
  strokeWeight(2) ;
  stroke(255,0,0);
  for (int k=1 ; k<nPoints ; k++) {    
    x1=k-1 ;
    x2=k ;
    float f1=linMap(0,nPoints,fStart,fStop,k-1) ;
    x1=(int)xMap(fStart,fStop,frameX0,frameX1,f1) ;
    float f2=linMap(0,nPoints,fStart,fStop,k) ;
    x2=(int)xMap(fStart,fStop,frameX0,frameX1,f2) ;
    float gain1=filterGain(f1) ;
    float gain2=filterGain(f2) ;
    y1=(int)(scaledBmTrace(gain1)) ;
    y2=(int)(scaledBmTrace(gain2)) ;
    line(x1, y1, x2, y2) ;
    }
  }
  
