import ddf.minim.*;
import ddf.minim.spi.AudioStream;
import ddf.minim.ugens.*;

float MHz=1e6 ;
float kHz=1e3 ;

float Ohm=1 ;
float mV=1e-3 ;

float pi=(float)Math.PI ;

// float dBmin=-50 ; float dBmax=100 ;
//float dBmin=-120-100 ; float dBmax=60 ;
float dBmin=-120 ; float dBmax=50 ;
float fSample=192000 ;
float fCursor=77500 ;

//float fStart=77500-15000 ;
//float fStop =77500+15000 ;

float fStart=10 ;
float fStop =fSample/2 ;

LpIIRfilter1 filter1=new LpIIRfilter1() ;

int  displaySizeX=1200 ;
int  displaySizeY=900 ;
int nPoints=displaySizeX*5 ;

int frameX0=60 ;
int frameX1=displaySizeX-10 ;
int frameY0=displaySizeY-10 ;
int frameY1=50 ;

float filterGain(float frq){
  float ii=cos(2*pi*frq/fSample) ;
  float qq=sin(2*pi*frq/fSample) ;
  float vv=filter1.tpabs(ii,qq) ;
  return vv ;
  }

void showLowPass1(){
  filter1.butter(4,(float)(1000.0/fSample) ) ;
  }

void showLowPass2(){
  filter1.tscheby(6,(float)(1000.0/fSample) , 0.2) ;
  }
  
void showLowPass3(){
  float omegac=2*PI*(1000) ; 
  float omegar=2*PI*(2000) ; 
  float bigA=1e3 ; 
  float eeps=(float) Math.exp(0.05)  ; 
  float bigt=1/fSample ;
  filter1.ellfil1(omegac,omegar,bigA,eeps,bigt) ;
  }  

void showBandPass1(){
  fStart=77500-15000 ;
  fStop =77500+15000 ;
  filter1.bandpass((float)(77500/fSample),0.99) ;
  }
  
void setup() {
  size(1200, 900);
  PFont font;
  font = createFont("Lucida Console", 10);
  textFont(font);
 
  showLowPass1() ;
  //showLowPass2() ;
  //showLowPass3() ;
  //showBandPass1() ;
  }
