public class IIRfilter {
  
  float sqr(float x){ return x*x ; }
//  float dBfun(float x){ return 20*log10(x) ; }
  float exp10(float x){ return pow(10.0,x) ; }   
  
 public float a0 ;
 public float[]  w1,w2,ca1,ca2,cb1,cb2,s1,s2 ;
 public int nsec ;
 
 float alphaLP=0.9 ;

  void getArrays(int nsecPar){
  nsec=nsecPar ;
  int nsec1=100 ;
  ca1=new float[nsec1] ;
  ca2=new float[nsec1] ;
  cb1=new float[nsec1] ;
  cb2=new float[nsec1] ;

  w1=new float[nsec] ;
  w2=new float[nsec] ;
  s1=new float[nsec] ;
  s2=new float[nsec] ;
  } 
  
  public float secabs(float x,float y,float a1,float a2){
  return sqr(x*x-y*y+a1*x+a2)+sqr(2*x*y+a1*y) ;
  }

float firstOrderGain(float x, float y) {
  float pRe=1-alphaLP ;
  float pIm=0 ;
  float absP=(float) sqrt(sqr(pRe)+sqr(pIm)) ;
  
  float ziRe=x ;
  float ziIm=y ;
  float qRe=1-alphaLP*ziRe ;
  float qIm=-alphaLP*ziIm ;
  float absQ=(float) sqrt(sqr(qRe)+sqr(qIm)) ;
  return absP/absQ ;
  }
   
public float tpabs(float x, float y){
  float hh ;
  hh=1 ;
  for (int  i=0 ; i<nsec ; i++){
    hh=hh*secabs(x,y,cb1[i],cb2[i])/secabs(x,y,ca1[i],ca2[i]) ;
    }
  hh=a0*sqrt(hh) ;
  return hh ;
  }
  
public void scaleAtFrequency(float omega){
  float hRef=tpabs(cos(omega),sin(omega)) ;  
    a0=a0/hRef ;
    }
  
public void resetIIR() {
  for (int  i=0 ; i<nsec ; i++){
      w1[i]=0 ; 
      w2[i]=0 ;
      s1[i]=0 ; 
      s2[i]=0 ;
      }
    }
    
public float run(float x){ 
    float w,w11,w22,y ;
    float s1New,s2New ;
    y=0 ;
    for (int  i=0 ; i<nsec ; i++){
/*
    w11=w1[i] ; 
      w22=w2[i] ;
      w=x-ca1[i]*w11-ca2[i]*w22 ;
      y=w+cb1[i]*w11+cb2[i]*w22 ;
      w2[i]=w11 ; 
      w1[i]=w ; 
      x=y ;
*/
      y=x+s1[i] ;
      s1New=-ca1[i]*s1[i]+(cb1[i]-ca1[i])*x+s2[i] ;
      s2New=-ca2[i]*s1[i]+(cb2[i]-ca2[i])*x ;
      s1[i]=s1New ;
      s2[i]=s2New ;
      x=y ;
      }
   return a0*y ;
   }
    
void tpmirror() {
// lowpass to highpass transform 
  System.out.println("tpmirror nsec="+nsec) ;
  for (int  i=0 ; i<nsec ; i++){
    ca1[i]=-ca1[i] ; 
    cb1[i]=-cb1[i] ; 
     }
  }  
    
  
}   
    

public class LpIIRfilter1 extends IIRfilter {
 
  float ln(float x){ return log(x) ; }

  public void bandpass(float frq,float rho){
    getArrays(1) ;
    ca1[0]=-2*rho*cos(frq*2*PI) ;
    ca2[0]=rho*rho ;
    cb1[0]=0 ;
    cb2[0]=-1 ;
    a0=1 ;
    }

  public void tscheby(int nOrd, float  frq, float rip){
    int i ; 
    float a0x,eps,a,b,s1,s2,t,c1,w,ww,u,v,d ;
    if ((nOrd % 2)!=0) { System.out.println("nord wrong in Tscheby") ; System.exit(1) ; }
    getArrays(nOrd / 2) ;
    a0x=1.0 ;
    eps=sqrt(1/sqr(1-rip)-1) ;
    s1=sqrt(1/sqr(eps)+1)+1/eps ;
    s1=exp(ln(s1)/nOrd) ;
    s2=1/s1 ; 
    a=0.5*(s1-s2) ;
    b=0.5*(s1+s2) ;
    int k=0 ;
    for (i=nOrd ; i<=3*nsec-1 ; i++){
      t=(2*i+1.0)/(2.0*nOrd)*PI ;
      c1=PI*frq ;
      w=sin(c1)/cos(c1) ;
      ww=w*w ;
      u=1-a*w*cos(t) ;
      d=u*u+b*b*ww*sqr(sin(t)) ;
      u=2*u/d-1 ;
      v=2*b*w*sin(t)/d ;
    
      ca1[k]=-2*u ;
      ca2[k]=u*u+v*v ;
      //System.out.println(String.format("ca1=%15.7f ca2=%15.7f",ca1[k],ca2[k])) ;
      cb1[k]=2 ; 
      cb2[k]=1 ;
      k++ ;
      a0x=a0x*(1-2*u+u*u+v*v)/4.0 ;
      //  writeln('1/a0x=',1/a0x) ;}
      }
    //writeln('a0=',a0x) ;}
    a0=a0x ;
    }


public void butter(int nOrd, float  frq) { 
  int i ; 
  float a0x,b,t,c1,w,ww,u,v,d;
  if ((nOrd % 2) != 0){ System.out.println("nord wrong in Butterworth") ; System.exit(1) ; }
  getArrays(nOrd / 2 ) ;
  a0x=1.0 ;
  int k=0 ;
  for( i=nOrd ; i<=3*nsec-1 ; i++){
    t=(2*i+1.0)/(2.0*nOrd)*PI ;
    c1=PI*frq ;
    w=sin(c1)/cos(c1) ;
    ww=w*w ;
    b=2*w ;
    d=1-b*cos(t)+ww ;
    u=(1-ww)/d ;
    v=b*sin(t)/d ;
  
    ca1[k]=-2*u ;
    ca2[k]=u*u+v*v ;
//{  writeln(b1[sectop],b2[sectop]) ;}
    cb1[k]=2 ; 
    cb2[k]=1 ;
    k++ ;
    a0x=a0x*(1-2*u+u*u+v*v)/4 ;
    }
  //{writeln('a0=',a0x) ;}
  a0=a0x ;
  }
}
