import ddf.minim.*;
import ddf.minim.spi.AudioStream;

float MHz=1e6 ;
float kHz=1e3 ;

float Ohm=1 ;
float mW=1e-3 ;
float pi=PI ;
float twopi=2.0*pi ;

float RXfrq=77500-5.5 ;
float RXgain=5e-3 ;
float PRNthreshold=1.6 ;
float AMthreshold=0.018 ;
boolean PLLon=true ;

float LOcos=0 ;
float LOsin=0 ;

float LOdeltaPhase=0 ;
float LOphase=0 ;

int nPoints=8192 ;
int streamBufferSize=32768 ;
float fSample1=192000.0 ;
//float fSample1=200000.0 ;
float tSample1=1.0/fSample1 ;
float carrierSampleFrequency=fSample1 ;
//float AGCgain=50 ;
float AGCgain=1 ;

//float bpRho=0.99 ;
float bpRho=0.95 ;

int displaySizeX=900 ;
int displaySizeY=600 ;
int yMidth=300 ;

LpIIRfilter1 inputFil1=new LpIIRfilter1() ;

LpIIRfilter1 filterPLLii=new LpIIRfilter1() ;
LpIIRfilter1 filterPLLqq=new LpIIRfilter1() ;

LpIIRfilter1 filterII=new LpIIRfilter1() ;
LpIIRfilter1 filterQQ=new LpIIRfilter1() ;

LpIIRfilter1 demodFil=new LpIIRfilter1() ;

//float AGCgain=2.2 ;

float AGCamplitudeEstimate=0 ;
int AGCcount=0 ;

int prnReg ;
int newBit ;
int prnSequenceLength=512 ;
int prnBuffer[]=new int[prnSequenceLength] ;
float CorelSum=0 ;

float ChipRate=77500.0/120.0 ;
int mm=3 ;
float DCFsampleRate=mm*ChipRate ;   
float DCFsamplePeriod=1.0/DCFsampleRate ;

float DCFsampleTimer=0 ;

float fSample2=DCFsampleRate ;

float RXbuffer[]=new float[mm*prnSequenceLength] ;
int RXbufferPtr=0 ;

Minim minim;
AudioStream input ;
MultiChannelBuffer buffer; 
int getPtr=Integer.MAX_VALUE ;

float sample=0 ;

float inpBuf[]=new float[nPoints] ;

int scopeSigChn=0 ;
int scopeCorelChn=0 ;
int scopeIIchn=0 ;
int scopeQQchn=0 ;
int scopeAmplChn=0 ;
int scopePhaseChn=0 ;
int scopeTimerChn=0 ;
int scopeThresholdChn=0 ;

//---------------------------------------------------------------------------------------  
  
float rms1=0 ;
float rms1Show ;

void readInpBuf(){
  rms1=0 ;
  getPtr=Integer.MAX_VALUE ;
  for(int k=0 ; k<nPoints ; k++){ 
    if(getPtr>=buffer.getBufferSize()){ 
      getPtr=0 ;
      input.read(buffer) ;
      }
    sample=buffer.getSample(0,getPtr) ;
    getPtr++ ;
    inpBuf[k]=sample ;
    rms1+=sqr(sample) ;
    }
  rms1Show=sqrt(rms1/nPoints) ;
  }

float IIsig=0 ;
float QQsig=0 ;
float phaseControl=0 ;
float signal ;

void mixInpBuf(){
  for (int xk=0 ; xk<nPoints ; xk++) {
    signal=RXgain*inputFil1.run(inpBuf[xk]) ;
    LOcos=cos( LOphase ) ;
    LOsin=sin( LOphase ) ;
    LOphase += LOdeltaPhase+phaseControl ;
    if(LOphase>twopi){ LOphase -= twopi ; }
    IIsig=filterII.run(signal*LOcos) ;
    QQsig=filterQQ.run(signal*LOsin) ;
    DCFsampleTimer+=tSample1 ;
    if(DCFsampleTimer>DCFsamplePeriod){
      DCFsampleTimer-=DCFsamplePeriod ;
      decode(AGCgain*IIsig,AGCgain*QQsig) ; 
      }
    }
  }      
  
void draw(){
  readInpBuf() ;
  mixInpBuf() ;
 // scopeClock() ;
  }
  
void settings(){
  size(displaySizeX, displaySizeY);
  }
  
XYscope1 xyScope=new XYscope1("myScope",400,400) ;
scopeClock scopeClock1=new scopeClock("myClock",500,500) ;

PFont font;
   
void setup(){
  println() ;
  println("PCasSDRxDCFprn2V05()...") ;
  font = createFont("Monospaced.bold", 16);
  textFont(font);
  
  xyScope.setup() ;
  scopeClock1.setup() ;
  
  LOphase=0 ;
  LOdeltaPhase=(RXfrq/fSample1*twopi) ;
  generateReSampledSequence1() ;
  
  minim = new Minim(this);
  fill(0,0,0) ;
  inputFil1.bandpass(RXfrq/fSample1,bpRho) ;
  
  filterPLLii.butter(2,2.0/fSample2 ) ;
  filterPLLqq.butter(2,2.0/fSample2 ) ;
    
  filterII.butter(4,800.0/fSample1 ) ;
  filterQQ.butter(4,800.0/fSample1 ) ;
  
   demodFil.butter(4,2.0/400) ;
   
 
  scopeSigChn=getChannel(50,2e1, color(255,0,0),true ,"Sig") ;
  scopeIIchn=getChannel(130,1e3, color(255,0,255),true ,"II" ) ;
  scopeQQchn=getChannel(180,1e3, color(255,0,255),true , "QQ") ;
  scopeAmplChn=getChannel(300,-2e3, color(255,255,0),true, "Ampl" ) ;
  scopeThresholdChn=getChannel(300,-2e3, color(255,255,255),true, "" ) ;
  scopeTimerChn=getChannel(350,-0.5, color(255,255,0),true , "Timer") ;
  scopePhaseChn=getChannel(430,15.0, color(255,255,255),true , "Phase") ;

   scopeCorelChn=getChannel(520,2.0e5, color(255,0,0),true ,"Corel") ;
    
    
  
  println(String.format("fSample1 = %12.2f ",fSample1)) ;
  println(String.format("fSample2 = %12.2f ",fSample2)) ;
  println("ChipRate=",ChipRate) ;
  println("DCFsampleRate= ",DCFsampleRate) ;
  input=minim.getInputStream(Minim.STEREO,streamBufferSize,(float)fSample1,16) ; // 
  input.open() ;
  buffer= new MultiChannelBuffer(1024, input.getFormat().getChannels());
  println("buffer.getChannelCount()="+buffer.getChannelCount()) ;
  println("buffer.getBufferSize()="+buffer.getBufferSize() ) ;
  clear() ;
  }
  
  
  
  
  
  
  
  
