#include "hardware/regs/addressmap.h"
#include "hardware/regs/sio.h"

.section ".scratch_x.", "ax"
@
@ Assembler function interpRectDDSloop
@
@ R1 - GPIO port address
@ R2 - bit value 0
@ R3 - bit value 1
@

.global ASMloop 		@ Provide function starting address 

.thumb_func                     @ Needed since SDK uses BX to call us
ASMloop:
    MOV   R2, #2
	MOV   R3, #1
	LDR   R1, siobase                 @ address we want
	ADD   R1, #SIO_GPIO_OUT_OFFSET    @ DAC port address
loop:	
	
	STRB  R2, [R1]	               @ send to port              1 cyc. 	
	STRB  R3, [R1]	               @ send to port              1 cyc. 	
	B     loop 		       @ loop for ever             2 cyc.
				       @                     total 4 cycles  	
@	MOV   PC,R4                    @ also needs 2 cycles

@---------------------------------------------------------------------------------------------

.align 4 

siobase: .word SIO_BASE @ base of the GPIO registers
	