extern "C" void interpRectDDSloop(void);

#define lane0 0
#define lane1 1
#define lane2 2
    
void abort(){
  printf("abort(): idle()...\n") ;
  while(1){}
  }

void interpCore1_sio_irq() {
  while (multicore_fifo_rvalid()){
    int rxVal = multicore_fifo_pop_blocking();
    interp0->base[lane0] = rxVal  ;
    }
  multicore_fifo_clear_irq();
  }

void interpCore1_setupIRQ() {
  multicore_fifo_clear_irq();
  irq_set_exclusive_handler(SIO_IRQ_PROC1, interpCore1_sio_irq);
  irq_set_enabled(SIO_IRQ_PROC1, true);
  printf("core1 irq set ok!\n") ;
   }

uint32_t interpRectDDSdelta(double frq){
  double ddsclk = 1000.0*cpuClkKhz/4.0;
  return (uint32_t)((frq*4294967296.0)/ddsclk) ;	
  }

void core1interpRectDDSdo(){
  interp_config cfg0 = interp_default_config();
 
  interp_config_set_shift(&cfg0, 31);
  interp_config_set_mask(&cfg0, 0, 0);
  interp_config_set_add_raw(&cfg0, true);
  interp_set_config(interp0,lane0, &cfg0);
  double frq=cpuClkKhz*kHz/6/4 ;
  interp0->base[lane0] = interpRectDDSdelta(frq) ;
  interp0->accum[lane0] = 0;
  printf("DDSdemo:\n") ;
  for (int i = 0; i < 20; ++i){
    int aa= interp0->accum[lane0] ;
    int pp=interp0->pop[lane2] ;
    printf("accu=%08Xh pp=%6d  = %08XH\n", aa,pp,pp);
    }

  interpCore1_setupIRQ() ;  
  printf("ready start  interpRectDDSloopt") ;
  interpRectDDSloop() ;
  } 

void interpRectDDStest(){
  printf("interpRectDDStest()....\n")  ;
  multicore_launch_core1(core1interpRectDDSdo);
  sleep_ms(1000) ;
  multicore_fifo_push_blocking(interpRectDDSdelta(125e3)) ;
  abort() ;
  while(1){
    multicore_fifo_push_blocking(interpRectDDSdelta(10e6)) ;
    sleep_ms(1000) ;
    multicore_fifo_push_blocking(interpRectDDSdelta(20e6)) ;
    sleep_ms(1000) ;
    }
  }   