 
// #include <stdio.h>
#include "hardware/pwm.h"
//#include <math.h>
//#include "hardware/structs/xip_ctrl.h"

#define PWMwrap 0x10000
#define PWM_PIN1 2    // GPIO2 pin 4
#define PWM_PIN2 3    // GPIO3 pin 5
#define GPIO4 4     // pin 6    
#define GPIO5 5     // pin 7    

#define us 1e-6
#define Ohm 1 
#define mW 1e-3 
#define kHz 1e3

uint slice_num1 ;
uint slice_num2 ;
volatile int pwm1=-1 ;
volatile int pwm2=-1 ;

void PWMsetup(){    
  printf("PWMsetup()\n") ;
  gpio_set_function(PWM_PIN1, GPIO_FUNC_PWM);
  gpio_set_function(PWM_PIN2, GPIO_FUNC_PWM);
   // Figure out which slice we just connected to the pin
  slice_num1 = pwm_gpio_to_slice_num(PWM_PIN1);
  slice_num2 = pwm_gpio_to_slice_num(PWM_PIN2);

  // Mask our slice's IRQ output into the PWM block's single interrupt line,
  // and register our interrupt handler
  //pwm_clear_irq(slice_num1);
  //pwm_set_irq_enabled(slice_num1, true);
  //irq_set_exclusive_handler(PWM_IRQ_WRAP, PWMirq1);
  //irq_set_enabled(PWM_IRQ_WRAP, true);
  //irq_set_enabled(PWM_IRQ_WRAP, false);
  
  // Get some sensible defaults for the slice configuration. 
  pwm_config config1 = pwm_get_default_config();
  // Set divider, reduces counter clock to sysclock/this value
  pwm_config_set_clkdiv(&config1, 1.f);
  pwm_config_set_output_polarity (&config1,0,0) ; // no invert A channel
  
  pwm_config_set_clkdiv_int 	(  &config1, 1) ;
	
  // Load the configuration into our PWM slice, and set it running.
  pwm_init(slice_num1, &config1, true);
  
  pwm_set_wrap(slice_num1,(PWMwrap-1) );
 
  pwm_set_gpio_level(PWM_PIN1, 50);
  pwm_set_gpio_level(PWM_PIN2, 60);

  printf("PWM_PIN1=%d\n",PWM_PIN1) ;
  printf("slice_num1=%d\n",slice_num1) ;
  
  printf("PWM_PIN2=%d\n",PWM_PIN2) ;
  printf("slice_num2=%d\n",slice_num2) ;

  printf("config1=%d\n",config1) ;
  printf("\n") ;
 // pwm_set_counter(slice_num1,0 ) ;
 // int cnt1=pwm_get_counter(slice_num1 ) ;
  }

int PWMdiv=1 ;

#define logStart 2  
#define logStop 10
int logPtr=0 ;
float logMean=0.0 ;
int  logMax=0.0 ;
int logStore[logStop] ;

#define PWMmeasure1Init\
  io_rw_32 * ctrPtr ;\
  int time ;\
  ctrPtr=&pwm_hw->slice[slice_num1].ctr ;\
  for(int k=0 ; k<logStop ; k++){ logStore[k]=0 ; }\
  logPtr=0 ;

#define PWMmeasure1Reset\
  for(int k=0 ; k<logStop ; k++){ logStore[k]=0 ; }\
  logPtr=0 ;
   
#define PWMmeasure1Start\
    *ctrPtr=0 ;

#define PWMmeasure1Stop\
  time=*ctrPtr ;\
  if(logPtr<logStop){ \
    logStore[logPtr++]=time ; \
    }

#define PWMmeasure1Show\
  logMean=0 ; logMax=0 ; \
  for(int k=0 ; k<logStop ; k++ ){\
    printf("PWMmeasure1show %3d %6d * %d\n",k,logStore[k],PWMdiv) ; }\
  for(int k=logStart ; k<logStop ; k++){ \
    logMean += logStore[k] ; \
    if(logStore[k]>logMax) { logMax=logStore[k] ; }\
    }\
  logMean=logMean/(logStop-logStart) ;\
  printf("max =%10d  *%d ",logMax,PWMdiv) ; \
  printf("mean=%10.3f *%d\n",logMean,PWMdiv) ;

//---------------------------------------------------------------------------------------- 

void Code3Nop(){
  printf("\nCode3Nop...\n") ;
  PWMmeasure1Init  
  for(int m=0 ; m<logStop ; m++){
    PWMmeasure1Start
    asm volatile("nop"); 
    asm volatile("nop"); 
    asm volatile("nop"); 
    PWMmeasure1Stop
    }
  PWMmeasure1Show
  }

void time100us(){
  printf("\ntime10us...\n") ;
  PWMmeasure1Init  
  for(int m=0 ; m<logStop ; m++){
    PWMmeasure1Start
    sleep_us(100) ;
    PWMmeasure1Stop
    }
  PWMmeasure1Show
  }

int main2(){
  printf("\n\nstart main2()... of module measureTimeWithPWM.c\n") ;
  PWMsetup() ;
  sleep_ms(100) ;
  Code3Nop() ;
  time100us() ;
  return 0;
}
