#include <stdio.h>
#include "pico/stdlib.h"
#include "hardware/structs/timer.h"
#include "hardware/structs/systick.h"
#include "pico/multicore.h"   
#include "pico/stdio.h"

#define cpuClkkHz 125000

#define us 1e-6
#define Ohm 1 
#define mW 1e-3 
#define kHz 1e3
#define ms 1e-3

void abort0(){
  printf("abort core0 idle-loop\n") ;
  while(1){}
  }

void abort1(){
  printf("abort core1 idle-loop\n") ;
  while(1){}
  }  

void busyWait(int nn){
  for(int k=0 ; k<nn  ;  k++){
    asm volatile("myLoop: nop");
    }
  }

#define oneSecond 25000000

void measureTime(char *text){
  int time1=time_us_32() ;
  busyWait(oneSecond) ;
  int time2=time_us_32() ;
  printf("%s delay %d us\n",text,time2-time1) ;
  }

void core1Do(){
  printf("\n\nStart core1\n");
  while(1){
    measureTime("core1") ;
    }
  } 

int main(){
 set_sys_clock_khz(cpuClkkHz, true);
  stdio_init_all();
  sleep_ms(200) ;
  printf("\n\nHello, dualCoreBusyWaiting1V01\n");
  printf("cpuClkkHz=%d\n",cpuClkkHz);
  measureTime("core0") ;
  measureTime("core0") ;
  measureTime("core0") ;
  multicore_launch_core1(core1Do);
  while(1){
    measureTime("core0") ;
    }
  }
