//  DK1VOK " 811 Reactivating and Reconditioning"
//  20240620
//  LCD 27, INA1 40, INA2 44,  RTC 68

#include "INA226.h"
#include <Wire.h>
#include <TimeLib.h>
#include <DS1307RTC.h>
#include <LiquidCrystal_I2C.h>           // LCD-I2C - Bibliothek
LiquidCrystal_I2C lcd(0x27,20,4);

float voltH = 0;            // Volt   1 Komma HEIZUNG
float voltA = 0;            // Volt   1 Komma   ANODE
float ampH  = 0;            // Ampere 1 Komma HEIZUNG
float ampA  = 0;            // Ampere 1 Komma   ANODE

int   volt12 = 0;     // BIT Versorgung Power pole Diode
int   volt05 = 0;     // BIT am Nano
float VOLT12 = 0;     // Volt Versorgung Power pole Diode
float VOLT05 = 0;     // Volt am Nano
unsigned long sekund =0;

INA226 INAH(0x40);  // Adresse Heizung
INA226 INAA(0x44);  // Adresse Anode

void setup()
{

  Wire.begin();
  if (!INAH.begin() )

  INAH.setAverage(7);              // <<<<<<<<<<<<<
  INAA.setAverage(7);              // <<<<<<<<<<<<<<<

   lcd.begin(20,4);               // 20 Zeichen, 4 Zeilen, mit PCF8574
   lcd.backlight();
   lcd.setCursor ( 0, 0 );   lcd.print ("DK1VOK   Senderoehre");
   lcd.setCursor ( 0, 1 );   lcd.print (" Amperex  811       ");
   lcd.setCursor ( 0, 2 );   lcd.print ("Reactivating and    ");
   lcd.setCursor ( 0, 3 );   lcd.print ("      Reconditioning");
   delay (5000);
   lcd.setCursor ( 0, 0 );   lcd.print ("                    ");   // LCD putzen
   lcd.setCursor ( 0, 1 );   lcd.print ("                    ");
   lcd.setCursor ( 0, 2 );   lcd.print ("                    ");
   lcd.setCursor ( 0, 3 );   lcd.print ("                    ");
   delay (10);

    tmElements_t tm;
   (RTC.read(tm));
    lcd.setCursor ( 0, 3 );
    lcd.print(tm.Day);
    lcd.print(".");
    lcd.print(tm.Month);
    lcd.print(".");
    lcd.print(tmYearToCalendar(tm.Year));

     lcd.setCursor ( 0, 1 );   lcd.print ("Heizg");
     lcd.setCursor ( 0, 0 );   lcd.print ("Anode");
     lcd.setCursor ( 19 , 1 ); lcd.print ("A");
     lcd.setCursor ( 19 , 0 ); lcd.print ("A");
     lcd.setCursor ( 11 , 1 ); lcd.print ("V");
     lcd.setCursor ( 11 , 0 ); lcd.print ("V");
  }

void loop()  {
  sekund = millis()/1000;         // Gesamt - Sekunden
  int  std = sekund /3600;
  lcd.setCursor( 0,2);  lcd.print(sekund); lcd.print(" s ");  //Sekunden
                        lcd.print(std);    lcd.print(" h ");    //Stunden
  // lcd.setCursor ( 17, 2 ); lcd.print("Av"); lcd.print(INAH.getAverage());

  volt12 = analogRead(A0);  // BIT Versorgung power pole
  volt05 = analogRead(A1);  // BIT  Nano LM78S05
  float VOLT12 = volt12 * (11.47 /853.0);   // Spannungsteiler 1044 + 400
  float VOLT05 = volt05 * (5.0 / 1023.0);   // direkt am Nano

  lcd.setCursor ( 11, 2 );  lcd.print ("     ");     // LCD putzen
  lcd.setCursor ( 12, 2 ); lcd.print(VOLT12,1);
  lcd.print (" ");         lcd.print(VOLT05,1);

 voltH =  (INAH.getBusVoltage());
 ampH  =  (INAH.getShuntVoltage_mV());
 ampH  =  (ampH /10); // UMRECHNEN xxxxxxxxxxxxxxxx
 voltA =  (INAA.getBusVoltage());
 ampA  =  (INAA.getShuntVoltage_mV());
 ampA  =  (ampA *0.02);   //UMRECHNEN xxxxxxxxxxxxxxxx

  lcd.setCursor ( 6, 1 );   lcd.print ("     ");     // LCD putzen
  lcd.setCursor ( 5, 0 );   lcd.print ("     ");
  lcd.setCursor ( 14,1 );   lcd.print ("     ");
  lcd.setCursor ( 14, 0 );  lcd.print ("     ");
  lcd.setCursor (18,3); lcd.print("  ");

 lcd.setCursor ( 6,  1 );   lcd.print (" ");          // LCD putzen
 lcd.setCursor ( 7,  1 );   lcd.print (voltH );
 lcd.setCursor ( 14, 1 );   lcd.print (ampH , 3);

 lcd.setCursor ( 6, 0 );   lcd.print(voltA,1);
 lcd.setCursor ( 14, 0 );  lcd.print(ampA , 3 );

  tmElements_t tm;
  if (RTC.read(tm)) {
  lcd.setCursor ( 12, 3 );
    lcd.print(tm.Hour); lcd.print(".");
    lcd.print(tm.Minute);lcd.print(".");
    lcd.print(tm.Second);

      delay(2000);
}     // -- END OF FILE --
